'use client' // Error boundaries must be Client Components

import { Text } from '@/components/typeography/text'
import { ClientErrorProps } from '@/types/utils'
import { useEffect } from 'react'

export default function Error({
  error,
}: ClientErrorProps) {
  useEffect(() => {
    console.error(error)
  }, [error])

  return (
    <div className="flex flex-col justify-center items-center gap-3 w-full h-2/3">
      <Text variant={"h2"} className='text-center'>The site is currently unavailable.</Text>
    </div>
  )
}
